/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.requests;

import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rcs.conndata.PhoneInfo;
import com.ibm.hwmca.fw.rcs.conndata.RetainUpdatableFile;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigData;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigManager;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigManager;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.XFrameRsfRequestBody;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public class PhoneListRequestBody
extends XFrameRsfRequestBody {
    private static String TRACE_MASKF = "XRSFPHLF";
    private static String TRACE_MASKT = "XRSFPHLT";
    private static String TRACE_MASKD = "XRSFPHLD";
    private HashMap fileMap = new HashMap();
    private PhoneFile[] fileList = null;
    public static final String RSF_PHONE_FILES_DOWNLOADED = "Files downloaded";

    public PhoneListRequestBody() {
        this.functionUserid = (char)69;
        this.functionId = (char)48;
    }

    public PhoneListRequestBody(PersistentData data) {
        super(((Persistent)data).parentData);
        this.fileList = ((Persistent)data).fileList;
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.parentData = super.getPersistentData();
        result.fileList = this.fileList;
        return result;
    }

    public boolean isValid() {
        return super.isValid() && this.fileList != null && this.fileList.length > 0;
    }

    public void initializeFileList(List files) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> PhoneListRequestBody::initializeFileList()");
        int numOfFiles = files.size();
        if (files == null || numOfFiles <= 0) {
            throw new IllegalArgumentException("No files contained in file list");
        }
        this.fileList = new PhoneFile[numOfFiles];
        for (int i = 0; i < numOfFiles; ++i) {
            RetainUpdatableFile updatableFile = (RetainUpdatableFile)files.get(i);
            String fileName = updatableFile.getRetainKey();
            String stagingPath = updatableFile.getStagedFile().getAbsolutePath();
            Trace.trace(TRACE_MASKF, "PhoneListRequestBody path='" + stagingPath + "' for '" + fileName + "'");
            String currentVersion = (String)updatableFile.getVersion();
            this.fileList[i] = new PhoneFile(fileName, stagingPath, currentVersion);
            this.fileMap.put(updatableFile.getRetainKey(), updatableFile);
        }
        Trace.trace(TRACE_MASKT, "<- PhoneListRequestBody::initializeFileList()");
    }

    public RetainUpdatableFile getRetainUpdatableFile(String retainFileName) {
        return (RetainUpdatableFile)this.fileMap.get(retainFileName);
    }

    public String showMapping() {
        return this.fileMap.toString();
    }

    public String getStagingFilePath(String retainFileName) {
        if (this.fileList == null) {
            return null;
        }
        for (int i = 0; i < this.fileList.length; ++i) {
            if (!this.fileList[i].fileName.equals(retainFileName)) continue;
            return this.fileList[i].filePath;
        }
        return null;
    }

    public String toXmlTransferFormat() {
        StringBuffer buffer = new StringBuffer(this.buildUseridAndFunction());
        buffer.append(super.toXmlTransferFormat());
        if (this.fileList != null && this.fileList.length > 0) {
            buffer.append("<FILELIST>");
            for (int i = 0; i < this.fileList.length; ++i) {
                buffer.append("<FN>" + this.fileList[i].fileName + "</FN>");
                buffer.append("<ID>" + this.fileList[i].id + "</ID>");
            }
            buffer.append("</FILELIST>");
        }
        ModemConfigManager modemCfgMgr = ModemConfigManager.getModemConfigManager();
        ModemConfigData modemCfgData = modemCfgMgr.getModemConfig();
        String globalDialPrefix = modemCfgData.getDialPrefix();
        OutboundConfigManager outCfgMgr = OutboundConfigManager.getOutboundConfigManager();
        OutboundConfigData outCfgData = outCfgMgr.getOutboundConfig();
        List phoneInfoList = outCfgData.getPhoneInfo();
        if (phoneInfoList.size() > 0) {
            buffer.append("<PNL>");
            for (int i = 0; i < phoneInfoList.size(); ++i) {
                String desc;
                String region;
                String country;
                String configPn;
                PhoneInfo phoneInfo = (PhoneInfo)phoneInfoList.get(i);
                buffer.append("<AL>");
                buffer.append("<AN>slot</AN><AV>" + i + "</AV>\n");
                String basePn = phoneInfo.getPredefinedNumber();
                if (!basePn.equals("")) {
                    buffer.append("<AN>basePn</AN><AV>" + basePn + "</AV>\n");
                }
                if (!(configPn = phoneInfo.getPhoneNumber()).equals("")) {
                    buffer.append("<AN>configPn</AN><AV>" + configPn + "</AV>\n");
                }
                if (!(country = phoneInfo.getIsoCountryCode()).equals("")) {
                    buffer.append("<AN>country</AN><AV>" + country + "</AV>\n");
                }
                if (!(region = phoneInfo.getIsoSubdivisionCode()).equals("")) {
                    buffer.append("<AN>region</AN><AV>" + region + "</AV>\n");
                }
                if (!(desc = phoneInfo.getDescription()).equals("")) {
                    buffer.append("<AN>desc</AN><AV>" + desc + "</AV>\n");
                }
                if (!globalDialPrefix.equals("")) {
                    buffer.append("<AN>prefix</AN><AV>" + globalDialPrefix + "</AV>\n");
                }
                buffer.append("<AN>multi</AN><AV>" + phoneInfo.isMultiSubdivision() + "</AV>\n");
                buffer.append("</AL>\n");
            }
            buffer.append("</PNL>\n");
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.buildUseridAndFunction());
        buffer.append(super.toString());
        if (this.fileList != null && this.fileList.length > 0) {
            buffer.append("<FILELIST>");
            buffer.append('\n');
            for (int i = 0; i < this.fileList.length; ++i) {
                buffer.append("  ");
                buffer.append("<FN>" + this.fileList[i].fileName + "</FN>");
                buffer.append("<ID>" + this.fileList[i].id + "</ID>");
                buffer.append('\n');
            }
            buffer.append("</FILELIST>");
            buffer.append('\n');
        }
        ModemConfigManager modemCfgMgr = ModemConfigManager.getModemConfigManager();
        ModemConfigData modemCfgData = modemCfgMgr.getModemConfig();
        String globalDialPrefix = modemCfgData.getDialPrefix();
        OutboundConfigManager outCfgMgr = OutboundConfigManager.getOutboundConfigManager();
        OutboundConfigData outCfgData = outCfgMgr.getOutboundConfig();
        List phoneInfoList = outCfgData.getPhoneInfo();
        if (phoneInfoList.size() > 0) {
            buffer.append("<PNL>");
            for (int i = 0; i < phoneInfoList.size(); ++i) {
                String desc;
                String region;
                String country;
                String configPn;
                PhoneInfo phoneInfo = (PhoneInfo)phoneInfoList.get(i);
                buffer.append("<AL>");
                buffer.append("<AN>slot</AN><AV>" + i + "</AV>\n");
                String basePn = phoneInfo.getPredefinedNumber();
                if (!basePn.equals("")) {
                    buffer.append("<AN>basePn</AN><AV>" + basePn + "</AV>\n");
                }
                if (!(configPn = phoneInfo.getPhoneNumber()).equals("")) {
                    buffer.append("<AN>configPn</AN><AV>" + configPn + "</AV>\n");
                }
                if (!(country = phoneInfo.getIsoCountryCode()).equals("")) {
                    buffer.append("<AN>country</AN><AV>" + country + "</AV>\n");
                }
                if (!(region = phoneInfo.getIsoSubdivisionCode()).equals("")) {
                    buffer.append("<AN>region</AN><AV>" + region + "</AV>\n");
                }
                if (!(desc = phoneInfo.getDescription()).equals("")) {
                    buffer.append("<AN>desc</AN><AV>" + desc + "</AV>\n");
                }
                if (!globalDialPrefix.equals("")) {
                    buffer.append("<AN>prefix</AN><AV>" + globalDialPrefix + "</AV>\n");
                }
                buffer.append("<AN>multi</AN><AV>" + phoneInfo.isMultiSubdivision() + "</AV>\n");
                buffer.append("</AL>\n");
            }
            buffer.append("</PNL>\n");
        }
        return buffer.toString();
    }

    private static class PhoneFile
    implements Serializable {
        public String fileName;
        public String filePath;
        public String id;

        public PhoneFile(String fileName, String filePath, String id) {
            this.fileName = fileName;
            this.filePath = filePath;
            this.id = id;
        }
    }

    private static class Persistent
    implements PersistentData {
        PersistentData parentData;
        PhoneFile[] fileList;
        int version = 0;
        private static final long serialVersionUID = 1L;

        private Persistent() {
        }
    }
}

